#ifndef usb_R8_1H
#define usb_R8_1H

#include <windows>
#include <setupapi>
#include <assert>
#include <iostream>
#include <sysutils.hpp>

#define searchMaxDevices 10 //maksymalna liczba interfejsw urzdzen

//---------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete x;
  x = NULL;
}
//---------------------------------------------------------
typedef USHORT USAGE, *PUSAGE;
typedef struct _HIDP_PREPARSED_DATA *PHIDP_PREPARSED_DATA;
//--------------------------------------------------------
typedef struct _HIDP_CAPS {
   USAGE Usage;
   USAGE UsagePage;
   USHORT InputReportByteLength;
   USHORT OutputReportByteLength;
   USHORT FeatureReportByteLength;
   USHORT Reserved[17];
   USHORT NumberLinkCollectionNodes;
   USHORT NumberInputButtonCaps;
   USHORT NumberInputValueCaps;
   USHORT NumberInputDataIndices;
   USHORT NumberOutputButtonCaps;
   USHORT NumberOutputValueCaps;
   USHORT NumberOutputDataIndices;
   USHORT NumberFeatureButtonCaps;
   USHORT NumberFeatureValueCaps;
   USHORT NumberFeatureDataIndices;
} HIDP_CAPS, *PHIDP_CAPS;
//---------------------------------------------------------
typedef struct _DEVICE_DATA {
  TCHAR   *HardwareId;
  TCHAR   *Path;
  DWORD   DeviceInstance;
  HANDLE  hidDeviceObject;
  BYTE    *inputReportBuffer;
  USHORT  inputReportByteLength;
  PHIDP_PREPARSED_DATA preparsedData;
  HIDP_CAPS capabilities;
} DEVICE_DATA, *PDEVICE_DATA;
//---------------------------------------------------------
class TUSBDevice {
   private:
      UINT fMemberIndex;
      void displayError(const char* msg);
   public:
      PDEVICE_DATA deviceList;
      BOOL getHidDeviceCapabilities(UINT memberIndex);
      UINT setGetHidDeviceData();
      HANDLE openHidUSBDevice(UINT memberIndex);
      BOOL readUSBReport(UINT memberIndex);
      BOOL closeHidUSBDevice(HANDLE devHandle);
      TUSBDevice(UINT memberIndex);
      ~TUSBDevice();
};
//---------------------------------------------------------
class Thread {
   private:
     static DWORD WINAPI ThreadFunc(void* parameter) {
        (reinterpret_cast<Thread *>(parameter))->runThread();
         return 0;
     }
   public:
     typedef DWORD threadID;
     HANDLE beginThread(){
          threadID id;
          return CreateThread(NULL, 0, ThreadFunc, this,
                              CREATE_SUSPENDED, &id);
     }
     virtual void runThread()=0;
     void resumeThread()  {ResumeThread(beginThread());}
     void closeHandle() {Win32Check(CloseHandle(beginThread()));}
};
//---------------------------------------------------------
class TThreadUSBPort: public Thread
{
   public:
      UINT interfaceIndex;
      void runThread();
};
//---------------------------------------------------------
#endif
